/* NoWindow v1.0
 * (c) 2005 Adsci Engineering, LLC
 * info@adsciengineering.com
 * http://www.adsciengineering.com/tools/nowindow
 * ================================= GNU GPL =================================
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ================================= GNU GPL =================================
*/


#include "stdafx.h"
#include "nowindow.h"
#include <windows.h>

int TellUserError(void);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	if (!strcmp(lpCmdLine,""))
	{
		MessageBox(NULL,"Syntax: nowindow.exe <command to execute>","You must specify a parameter!",MB_ICONSTOP);
		return 1;
	}

	PROCESS_INFORMATION NoWindowPI;
	STARTUPINFO NoWindowSI; GetStartupInfo(&NoWindowSI);
	if (CreateProcess(NULL,lpCmdLine,NULL,NULL,true,CREATE_NO_WINDOW,NULL,NULL,&NoWindowSI,&NoWindowPI))
	{
		return 0;
	}
	else
		return TellUserError();
	
}

int TellUserError(void){
	int error;
	if(!(error = GetLastError())) return 0; 
	LPVOID lpMsgBuf;
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		error,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);

	OutputDebugString((LPCTSTR)lpMsgBuf);
	MessageBox(NULL,(LPCTSTR) lpMsgBuf, "Error", NULL);
	LocalFree( lpMsgBuf );
	return error;
}


