/* NoWindow v1.0
 * (c) 2005 Adsci Engineering, LLC
 * info@adsciengineering.com OR andrew.budd@adsciengineering.com
 * http://www.adsciengineering.com/tools/nowindow
 * ================================= GNU GPL =================================
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ================================= GNU GPL =================================
*/


#include "stdafx.h"
#include "nowindow.h"
#include <windows.h>

int TellUserError(void);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	PROCESS_INFORMATION NoWindowPI;
	STARTUPINFO NoWindowSI; 
	OSVERSIONINFO verinfo;
	SECURITY_ATTRIBUTES SAProcess,SAThread;
	DWORD nowindow_flag = CREATE_NO_WINDOW;

	if (!strcmp(lpCmdLine,""))
	{
		MessageBox(NULL,"Syntax: nowindow.exe <command to execute>","You must specify a parameter!",MB_ICONSTOP);
		return 1;
	}
	
	//check operating system
	verinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if (GetVersionEx(&verinfo) && verinfo.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
			nowindow_flag = DETACHED_PROCESS; //95, 98, me

	
	//handle the security attributes
	SAProcess.nLength = sizeof(SECURITY_ATTRIBUTES);
	SAThread.nLength = sizeof(SECURITY_ATTRIBUTES);

	//by nulling these, we will force CreateProcess to use the default security descriptor
	SAProcess.lpSecurityDescriptor = NULL;
	SAThread.lpSecurityDescriptor = NULL;

	//get startup info
	NoWindowSI.cb = sizeof(STARTUPINFO);
	GetStartupInfo(&NoWindowSI);
	
	if (CreateProcess(NULL,lpCmdLine,&SAProcess,&SAThread,true,nowindow_flag,NULL,NULL,&NoWindowSI,&NoWindowPI))
	{
		//cleanup handles
		CloseHandle(NoWindowPI.hProcess);
		CloseHandle(NoWindowPI.hThread);
		return 0;
	}
	else
		return TellUserError();
	
}

int TellUserError(void){
	int error;
	if(!(error = GetLastError())) return 0; 
	LPVOID lpMsgBuf;
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		error,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);

	OutputDebugString((LPCTSTR)lpMsgBuf);
	MessageBox(NULL,(LPCTSTR) lpMsgBuf, "Error", NULL);
	LocalFree( lpMsgBuf );
	return error;
}


