/* ShoveAffinity 1.0 (c) 2006 Adsci Engineering, LLC
 *	info@adsciengineering.com
 *
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "stdafx.h"
#include <windows.h>
#include <tlhelp32.h>

#define IS_SET(flag, bit)	((flag) & (bit))
#define SET_BIT(var, bit)	((var) |= (bit))

int _tmain(int argc, _TCHAR* argv[])
{
	HANDLE hProcess;
	DWORD procs = 0, system_mask = 0 ,proc_mask = 0;
	OSVERSIONINFO verinfo;

	if (argc < 2)
	{printf("Argument 1-n: Processor IDs, #( 0 - 31 supported)\n\nExample: ShoveAffinity 0 1\n\n");return 1;}

	//check operating system
	verinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if (GetVersionEx(&verinfo) && verinfo.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
	{
		printf("WinNT/2000/XP REQUIRED!\n");
		return 1;
	}

	GetProcessAffinityMask(GetCurrentProcess(),&proc_mask,&system_mask);

	for (int i=1; i < argc; i++)
		if (IS_SET(system_mask,( 1 << atoi(argv[i]))))
			SET_BIT(procs, ( 1 << atoi(argv[i]) ) );
		else
			printf("Processor ID: %d is not valid, and will be ignored.\n",atoi(argv[i]));

	HANDLE h = CreateToolhelp32Snapshot(TH32CS_SNAPTHREAD, 0);
	if (h != INVALID_HANDLE_VALUE) 
	{
		THREADENTRY32 te;
		te.dwSize = sizeof(te);
		if (Thread32First(h, &te)) 
		{
			do {
				if (te.dwSize >= FIELD_OFFSET(THREADENTRY32, th32OwnerProcessID) + sizeof(te.th32OwnerProcessID)) 
				{
					hProcess = OpenProcess(MAXIMUM_ALLOWED,false,te.th32OwnerProcessID);
					SetProcessAffinityMask(hProcess,procs);
					CloseHandle(hProcess);
				}
				te.dwSize = sizeof(te);
			} while (Thread32Next(h, &te));
		}
		CloseHandle(h);
	}
	return 0;
}

